package gov.va.vinci.dart.json;

import javax.xml.bind.annotation.XmlType;

@XmlType(name="documentversion", propOrder={
		"id",
		"name",
		"updatedBy",
		"updatedOn",
		"versionNumber"
})
public class DocumentVersionView implements Comparable {

	private int id;
	private String name;

	private String updatedBy;
	private String updatedOn;
	private int versionNumber;

	public int getId() {
		return id;
	}
	
	public void setId(int id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}
	
	public void setName(String name) {
		this.name = name;
	}
	
	public String getUpdatedBy() {
		return updatedBy;
	}
	
	public void setUpdatedBy(String updatedBy) {
		this.updatedBy = updatedBy;
	}
	
	public String getUpdatedOn() {
		return updatedOn;
	}
	
	public void setUpdatedOn(String updatedOn) {
		this.updatedOn = updatedOn;
	}
	
	public int getVersionNumber() {
		return versionNumber;
	}
	
	public void setVersionNumber(int versionNumber) {
		this.versionNumber = versionNumber;
	}
	


	/**
	 * Sort by version number, ascending
	 */
	@Override
	public int compareTo(Object o) {
		if (o == null) {
			return -1;
		}
		if (DocumentVersionView.class.isAssignableFrom(o.getClass()) == false) {
			return -1;
		}
		
		DocumentVersionView doc2 = (DocumentVersionView)o;

		if (doc2.versionNumber == this.versionNumber) {
			return 0;
		}
		return (doc2.versionNumber < this.versionNumber) ? 1: -1;
	}
	
	
}
